//
//  CMSFeedListViewController.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 11/11/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
let STORYBOARD_ID_CMSFeedListViewController = "CMSFeedListViewController"
class CMSFeedListViewController: UITableViewController {

    var dataSource = [AnyObject]()
    var feedUrl = ""



    convenience override init(feedUrl url: String) {
        var storyboard = UIStoryboard(name: CMS_STORYBOARD_NAME, bundle: nil)
        self = storyboard.instantiateViewControllerWithIdentifier(STORYBOARD_ID_CMSFeedListViewController)
        
        feedUrl = url
    
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = "Loading..."
        if feedUrl == "" {
            feedUrl = DEFAULT_FEED_URL
        }
        var req = NSURLRequest(URL: NSURL(string: feedUrl)!)!
        RSSParser.parseRSSFeedForRequest(req, success: {(feedItems: [AnyObject]) -> Void in
            self.title = "Blog"
            self.dataSource = feedItems
            self.tableView.reloadData()
        }, failure: {(error: NSError) -> Void in
            self.title = "Error"
            print("Error: \(error)")
        })
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
// MARK: - Table view data source

    override func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        // Return the number of sections.
        return 1
    }

    override func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        // Return the number of rows in the section.
        return dataSource.count
    }

    override func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        var item = dataSource[indexPath.row]
        var cell = tableView.dequeueReusableCellWithIdentifier(item.title)!
        if cell == nil {
            cell = UITableViewCell(style: .Default, reuseIdentifier: item.title)
        }
        // Configure the cell...
        cell.accessoryType = .DisclosureIndicator
        cell.textLabel!.text! = item.title
        if item.imagesFromItemDescription().count > 0 {
            cell.imageView!.setImageWithURL(NSURL(string: item.imagesFromItemDescription[0])!, placeholderImage: UIImage(named: nil)!)
        }
        return cell
    }

    override func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        var storyboard = UIStoryboard(name: CMS_STORYBOARD_NAME, bundle: nil)
        var detailView = storyboard.instantiateViewControllerWithIdentifier(STORYBOARD_ID_CMSFeedDetailViewController)
        detailView.feedItem = dataSource[indexPath.row]
        self.navigationController!.pushViewController(detailView, animated: true)
    }
}
//
//  CMSFeedListViewController.m
//  Composr Mobile SDK
//
//  Created by Aaswini on 11/11/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
let DEFAULT_FEED_URL = "http://ocportal.com/backend.php?type=RSS2&mode=news&days=300&max=100&keep_session=1245593369"